(*| 15:53 29/12/1987 *)
UNIT KeyBoard;

INTERFACE

USES Crt,StdTypes;

{MODULE: KEYBOARD}

{Keyboard handling routines.}

FUNCTION KeyReady: Boolean;

PROCEDURE GetKey(Var Key: Char;Var KeyFunc: Keytype);

IMPLEMENTATION

FUNCTION KeyReady: Boolean;

BEGIN
  KeyReady:=KeyPressed;
END;  {KeyReady}

PROCEDURE GetKey(Var Key: Char;Var KeyFunc: Keytype);
{ Get a character from keyboard if available and work out its value.}

Var Ch: Char;

BEGIN
  IF KeyReady THEN BEGIN
    Ch:=ReadKey;
    IF (Ch=#0) AND KeyReady THEN BEGIN
      { function key escape sequence}
      Ch:=ReadKey;  {get 2nd char. of esc sequence}
      CASE Ord(Ch) OF
        59 : KeyFunc:= F1;
        60 : KeyFunc:= F2;
        61 : KeyFunc:= F3;
        62 : KeyFunc:= F4;
        63 : KeyFunc:= F5;
        64 : KeyFunc:= F6;
        65 : KeyFunc:= F7;
        66 : KeyFunc:= F8;
        67 : KeyFunc:= F9;
        68 : KeyFunc:= F10;

        75 : KeyFunc:= Cleft;
        77 : KeyFunc:= Cright;
        72 : KeyFunc:= Cup;
        80 : KeyFunc:= Cdown;
        71 : KeyFunc:= Chome;
        79 : KeyFunc:= Cend;
        73 : KeyFunc:= Cpgup;
        81 : KeyFunc:= Cpgdown;
        82 : KeyFunc:= Cins;
        83 : KeyFunc:= Cdel;
        15 : KeyFunc:= RTab;
       ELSE KeyFunc:= Inval;
      END   {Case Of Ch}
     END {If begin}
    ELSE BEGIN
      {non escape sequence keys.}
      CASE Ord(Ch) OF
        08 : KeyFunc:= BS;
        13 : KeyFunc:= Ret;
        09 : KeyFunc:= Tab;
        27 : KeyFunc:= Esc;
       ELSE BEGIN
         {normal printable keys}
         KeyFunc:= Normal;
         Key:= Ch;
       END;
      END;  {Case Of Ch}
    END
   END {If begin}
  ELSE KeyFunc:= none;  {no key pressed}
END;  {GetKey}

END.
